library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity Voter is
	port
		(reset: in boolean;
		 clk: in std_logic;
		 inp: in std_logic;
		 outp : out std_logic);
end Voter;

architecture RTL of Voter is

signal sr: std_logic_vector(0 to 2);
signal op: std_logic;

begin

-- this should translate to a LUT pretty well
outp <= op;

process (reset, clk, inp)
begin
	if reset then
		sr <= (others => '0');
		op <= '0';
	elsif rising_edge(clk) then

		sr(0 to 1) <= sr(1 to 2);
		sr(2) <= inp;

		if (op = '0') and (sr = "111") then
			op <= '1';
		elsif (op = '1') and (sr = "000") then
			op <= '0';
		end if;
	end if;
end process;

end RTL;
