library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity PosEdge is
    port ( reset: in boolean;
	 		  clk, inp: in std_logic;
           outp: out std_logic);
end PosEdge;

architecture RTL of PosEdge is

signal inp_prev: std_logic;

begin

	process (reset, clk, inp)
	begin
		if reset then
			outp <= '0';
		elsif rising_edge(clk) then
			inp_prev <= inp;
			if (inp = '1') and (inp_prev = '0') then
				outp <= '1' after 10 ns;
			else
				outp <= '0' after 10 ns;
			end if;
		end if;
	end process;

end RTL;
