library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

package IOB_Config is

-- generic types
subtype DevID is unsigned(0 to 5);
subtype DevCmd is unsigned(0 to 2);

-- video terminal
---- default address is 40, "second TTY"
constant VT52IBASE: DevID := O"40";
constant VT52OBASE: DevID := O"41";

-- serial ports
constant NUMUARTS: integer := 3;

type UARTIDArray is array (0 to NUMUARTS-1) of DevID;

---- default addresses are 30,32,34,... "VT78 serial"
constant UARTIBASE: UARTIDArray := (O"30", O"32", O"34");
constant UARTOBASE: UARTIDArray := (O"31", O"33", O"35");

-- parallel printer port
---- default address is 65, "Serial printer"
constant PARPTIBASE: DevID := O"65";
constant PARPTOBASE: DevID := O"66";

-- IOTs for PIO
--constant PIOBASE:  DevID := O"36";	-- set to "00" to remove PIO code
constant PIOBASE:  DevID := O"00";
constant PIOSETBANK: DevCmd := O"0";
constant PIOSETDIR: DevCmd := O"1";
constant PIOSETBITS: DevCmd := O"2";

-- IOT for FPGA configuration
constant SPCBASE: DevID := O"36";	-- shared with PIO
constant SPCREPROG: DevCmd := O"6";

-- standard IOT input instructions
constant KCF: DevCmd := O"0";
constant KSF: DevCmd := O"1";
constant KCC: DevCmd := O"2";
constant KRS: DevCmd := O"4";
constant KIE: DevCmd := O"5";
constant KRB: DevCmd := O"6";

-- standard IOT output instructions
constant TFL: DevCmd := O"0";
constant TSF: DevCmd := O"1";
constant TCF: DevCmd := O"2";
constant TPC: DevCmd := O"4";
constant TSK: DevCmd := O"5";
constant TLS: DevCmd := O"6";

end IOB_Config;
