library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.numeric_std.ALL;

package VT52_cfg is

	constant ROWS: integer := 24;
	constant COLUMNS: integer := 80;
	constant CELLH: integer := 8;
	constant CELLV: integer := 16;

	subtype ROW is integer range 0 to ROWS-1;
	subtype COLUMN is integer range 0 to COLUMNS-1;
	subtype RGB is std_logic_vector(0 to 2);

	constant FOREG: RGB := "111";
	constant BACKG: RGB := "000";
	constant CURSBLINK: boolean := true;
	constant CURSBLOCK: boolean := false;

end VT52_cfg;
