--
--   Copyright (C) 2003 by J. Kearney, Bolton, Massachusetts
--
--   This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
-- for more details.
--
--   You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

library unisim;
use unisim.vcomponents.all;

entity CG8x16 is
    Port ( clk : in std_logic;
 			  char : in std_logic_vector(6 downto 0);
           row : in integer range 0 to 15;
           outp : out std_logic_vector(7 downto 0));
end CG8x16;

architecture RTL of CG8x16 is

  attribute INIT_00: string;  attribute INIT_01: string; attribute INIT_02: string;  attribute INIT_03: string;
  attribute INIT_04: string;  attribute INIT_05: string; attribute INIT_06: string;  attribute INIT_07: string;
  attribute INIT_08: string;  attribute INIT_09: string; attribute INIT_0A: string;  attribute INIT_0B: string;
  attribute INIT_0C: string;  attribute INIT_0D: string; attribute INIT_0E: string;  attribute INIT_0F: string;

  attribute INIT_00 of rom1 : label is "0000183c3c3c1818180018180000000000000000000000000000000000000000";
  attribute INIT_01 of rom1 : label is "0000006c6cfe6c6c6cfe6c6c0000000000666666240000000000000000000000";
  attribute INIT_02 of rom1 : label is "00000000c2c60c183060c6860000000018187cc6c2c07c060686c67c18180000";
  attribute INIT_03 of rom1 : label is "003030306000000000000000000000000000386c6c3876dccccccc7600000000";
  attribute INIT_04 of rom1 : label is "000030180c0c0c0c0c0c18300000000000000c18303030303030180c00000000";
  attribute INIT_05 of rom1 : label is "000000000018187e18180000000000000000000000663cff3c66000000000000";
  attribute INIT_06 of rom1 : label is "00000000000000fe000000000000000000000000000000000018181830000000";
  attribute INIT_07 of rom1 : label is "0000000002060c183060c0800000000000000000000000000000181800000000";
  attribute INIT_08 of rom1 : label is "00001838781818181818187e0000000000003c66c3c3dbdbc3c3663c00000000";
  attribute INIT_09 of rom1 : label is "00007cc606063c060606c67c0000000000007cc6060c183060c0c6fe00000000";
  attribute INIT_0A of rom1 : label is "0000fec0c0c0fc060606c67c0000000000000c1c3c6cccfe0c0c0c1e00000000";
  attribute INIT_0B of rom1 : label is "0000fec606060c18303030300000000000003860c0c0fcc6c6c6c67c00000000";
  attribute INIT_0C of rom1 : label is "00007cc6c6c67e0606060c780000000000007cc6c6c67cc6c6c6c67c00000000";
  attribute INIT_0D of rom1 : label is "0000000018180000001818300000000000000000181800000018180000000000";
  attribute INIT_0E of rom1 : label is "00000000007e00007e00000000000000000000060c18306030180c0600000000";
  attribute INIT_0F of rom1 : label is "00007cc6c60c181818001818000000000000006030180c060c18306000000000";
 
  attribute INIT_00 of rom2 : label is "000010386cc6c6fec6c6c6c6000000000000007cc6c6dedededcc07c00000000";
  attribute INIT_01 of rom2 : label is "00003c66c2c0c0c0c0c2663c000000000000fc6666667c66666666fc00000000";
  attribute INIT_02 of rom2 : label is "0000fe6662687868606266fe000000000000f86c6666666666666cf800000000";
  attribute INIT_03 of rom2 : label is "00003c66c2c0c0dec6c6663a000000000000fe6662687868606060f000000000";
  attribute INIT_04 of rom2 : label is "00003c18181818181818183c000000000000c6c6c6c6fec6c6c6c6c600000000";
  attribute INIT_05 of rom2 : label is "0000e666666c78786c6666e60000000000001e0c0c0c0c0ccccccc7800000000";
  attribute INIT_06 of rom2 : label is "0000c3e7ffffdbc3c3c3c3c3000000000000f06060606060606266fe00000000";
  attribute INIT_07 of rom2 : label is "00007cc6c6c6c6c6c6c6c67c000000000000c6e6f6fedecec6c6c6c600000000";
  attribute INIT_08 of rom2 : label is "00007cc6c6c6c6c6c6d6de7c0c0e00000000fc6666667c60606060f000000000";
  attribute INIT_09 of rom2 : label is "00007cc6c660380c06c6c67c000000000000fc6666667c6c666666e600000000";
  attribute INIT_0A of rom2 : label is "0000c6c6c6c6c6c6c6c6c67c000000000000ffdb991818181818183c00000000";
  attribute INIT_0B of rom2 : label is "0000c3c3c3c3c3dbdbff6666000000000000c3c3c3c3c3c3c3663c1800000000";
  attribute INIT_0C of rom2 : label is "0000c3c3c3663c181818183c000000000000c3c3663c18183c66c3c300000000";
  attribute INIT_0D of rom2 : label is "00003c30303030303030303c000000000000ffc3860c183060c1c3ff00000000";
  attribute INIT_0E of rom2 : label is "00003c0c0c0c0c0c0c0c0c3c0000000000000080c0e070381c0e060200000000";
  attribute INIT_0F of rom2 : label is "00000000000000000000000000ff000010386cc6000000000000000000000000";
 
  attribute INIT_00 of rom3 : label is "0000000000780c7ccccccc760000000030301800000000000000000000000000";
  attribute INIT_01 of rom3 : label is "00000000007cc6c0c0c0c67c000000000000e06060786c666666667c00000000";
  attribute INIT_02 of rom3 : label is "00000000007cc6fec0c0c67c0000000000001c0c0c3c6ccccccccc7600000000";
  attribute INIT_03 of rom3 : label is "000000000076cccccccccc7c0ccc78000000386c6460f060606060f000000000";
  attribute INIT_04 of rom3 : label is "00001818003818181818183c000000000000e060606c7666666666e600000000";
  attribute INIT_05 of rom3 : label is "0000e06060666c78786c66e60000000000000606000e06060606060666663c00";
  attribute INIT_06 of rom3 : label is "0000000000e6ffdbdbdbdbdb0000000000003818181818181818183c00000000";
  attribute INIT_07 of rom3 : label is "00000000007cc6c6c6c6c67c000000000000000000dc66666666666600000000";
  attribute INIT_08 of rom3 : label is "000000000076cccccccccc7c0c0c1e000000000000dc66666666667c6060f000";
  attribute INIT_09 of rom3 : label is "00000000007cc660380cc67c000000000000000000dc7666606060f000000000";
  attribute INIT_0A of rom3 : label is "0000000000cccccccccccc76000000000000103030fc30303030361c00000000";
  attribute INIT_0B of rom3 : label is "0000000000c3c3c3dbdbff66000000000000000000c3c3c3c3663c1800000000";
  attribute INIT_0C of rom3 : label is "0000000000c6c6c6c6c6c67e060cf8000000000000c3663c183c66c300000000";
  attribute INIT_0D of rom3 : label is "00000e18181870181818180e000000000000000000fecc183060c6fe00000000";
  attribute INIT_0E of rom3 : label is "0000701818180e18181818700000000000001818181800181818181800000000";
  attribute INIT_0F of rom3 : label is "0000000010386cc6c6c6fe0000000000000076dc000000000000000000000000";

  signal address: std_logic_vector(8 downto 0);
  signal c1, c2, c3: std_logic_vector(7 downto 0);

  constant zero: std_logic_vector(7 downto 0) := (others => '0');

begin


	address <= char(4 downto 0) & std_logic_vector(to_unsigned(row, 4));

	outp <= c1 when char(6 downto 5) = "01" else
			  c2 when char(6 downto 5) = "10" else
			  c3 when char(6 downto 5) = "11" else
			  zero;

   rom1: RAMB4_S8
-- n.b. this copy is needed for simulation
-- synopsys translate_off
    generic map
      (
      INIT_00 => X"0000183c3c3c1818180018180000000000000000000000000000000000000000",
      INIT_01 => X"0000006c6cfe6c6c6cfe6c6c0000000000666666240000000000000000000000",
      INIT_02 => X"00000000c2c60c183060c6860000000018187cc6c2c07c060686c67c18180000",
      INIT_03 => X"003030306000000000000000000000000000386c6c3876dccccccc7600000000",
      INIT_04 => X"000030180c0c0c0c0c0c18300000000000000c18303030303030180c00000000",
      INIT_05 => X"000000000018187e18180000000000000000000000663cff3c66000000000000",
      INIT_06 => X"00000000000000fe000000000000000000000000000000000018181830000000",
      INIT_07 => X"0000000002060c183060c0800000000000000000000000000000181800000000",
      INIT_08 => X"00001838781818181818187e0000000000003c66c3c3dbdbc3c3663c00000000",
      INIT_09 => X"00007cc606063c060606c67c0000000000007cc6060c183060c0c6fe00000000",
      INIT_0A => X"0000fec0c0c0fc060606c67c0000000000000c1c3c6cccfe0c0c0c1e00000000",
      INIT_0B => X"0000fec606060c18303030300000000000003860c0c0fcc6c6c6c67c00000000",
      INIT_0C => X"00007cc6c6c67e0606060c780000000000007cc6c6c67cc6c6c6c67c00000000",
      INIT_0D => X"0000000018180000001818300000000000000000181800000018180000000000",
      INIT_0E => X"00000000007e00007e00000000000000000000060c18306030180c0600000000",
      INIT_0F => X"00007cc6c60c181818001818000000000000006030180c060c18306000000000"
      )
-- synopsys translate_on
  port map
      (WE => '0', EN => '1', RST => '0', CLK => clk,
       ADDR => address, DI => zero, DO => c1);
 
   rom2: RAMB4_S8
-- n.b. this copy is needed for simulation
-- synopsys translate_off
    generic map
      (
      INIT_00 => X"000010386cc6c6fec6c6c6c6000000000000007cc6c6dedededcc07c00000000",
      INIT_01 => X"00003c66c2c0c0c0c0c2663c000000000000fc6666667c66666666fc00000000",
      INIT_02 => X"0000fe6662687868606266fe000000000000f86c6666666666666cf800000000",
      INIT_03 => X"00003c66c2c0c0dec6c6663a000000000000fe6662687868606060f000000000",
      INIT_04 => X"00003c18181818181818183c000000000000c6c6c6c6fec6c6c6c6c600000000",
      INIT_05 => X"0000e666666c78786c6666e60000000000001e0c0c0c0c0ccccccc7800000000",
      INIT_06 => X"0000c3e7ffffdbc3c3c3c3c3000000000000f06060606060606266fe00000000",
      INIT_07 => X"00007cc6c6c6c6c6c6c6c67c000000000000c6e6f6fedecec6c6c6c600000000",
      INIT_08 => X"00007cc6c6c6c6c6c6d6de7c0c0e00000000fc6666667c60606060f000000000",
      INIT_09 => X"00007cc6c660380c06c6c67c000000000000fc6666667c6c666666e600000000",
      INIT_0A => X"0000c6c6c6c6c6c6c6c6c67c000000000000ffdb991818181818183c00000000",
      INIT_0B => X"0000c3c3c3c3c3dbdbff6666000000000000c3c3c3c3c3c3c3663c1800000000",
      INIT_0C => X"0000c3c3c3663c181818183c000000000000c3c3663c18183c66c3c300000000",
      INIT_0D => X"00003c30303030303030303c000000000000ffc3860c183060c1c3ff00000000",
      INIT_0E => X"00003c0c0c0c0c0c0c0c0c3c0000000000000080c0e070381c0e060200000000",
      INIT_0F => X"00000000000000000000000000ff000010386cc6000000000000000000000000"
      )
-- synopsys translate_on
  port map
      (WE => '0', EN => '1', RST => '0', CLK => clk,
       ADDR => address, DI => zero, DO => c2);
 
   rom3: RAMB4_S8
-- n.b. this copy is needed for simulation
-- synopsys translate_off
    generic map
      (
      INIT_00 => X"0000000000780c7ccccccc760000000030301800000000000000000000000000",
      INIT_01 => X"00000000007cc6c0c0c0c67c000000000000e06060786c666666667c00000000",
      INIT_02 => X"00000000007cc6fec0c0c67c0000000000001c0c0c3c6ccccccccc7600000000",
      INIT_03 => X"000000000076cccccccccc7c0ccc78000000386c6460f060606060f000000000",
      INIT_04 => X"00001818003818181818183c000000000000e060606c7666666666e600000000",
      INIT_05 => X"0000e06060666c78786c66e60000000000000606000e06060606060666663c00",
      INIT_06 => X"0000000000e6ffdbdbdbdbdb0000000000003818181818181818183c00000000",
      INIT_07 => X"00000000007cc6c6c6c6c67c000000000000000000dc66666666666600000000",
      INIT_08 => X"000000000076cccccccccc7c0c0c1e000000000000dc66666666667c6060f000",
      INIT_09 => X"00000000007cc660380cc67c000000000000000000dc7666606060f000000000",
      INIT_0A => X"0000000000cccccccccccc76000000000000103030fc30303030361c00000000",
      INIT_0B => X"0000000000c3c3c3dbdbff66000000000000000000c3c3c3c3663c1800000000",
      INIT_0C => X"0000000000c6c6c6c6c6c67e060cf8000000000000c3663c183c66c300000000",
      INIT_0D => X"00000e18181870181818180e000000000000000000fecc183060c6fe00000000",
      INIT_0E => X"0000701818180e18181818700000000000001818181800181818181800000000",
      INIT_0F => X"0000000010386cc6c6c6fe0000000000000076dc000000000000000000000000"
      )
-- synopsys translate_on
  port map
      (WE => '0', EN => '1', RST => '0', CLK => clk,
       ADDR => address, DI => zero, DO => c3);

end RTL;
